#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `timezone` varchar(256) NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `timezone`, `logo`) VALUES (1, '10 Kudus', '085740621654', '10kudus.data@gmail.com', 'kudus', 'Asia/Jakarta', '');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kategori
#

DROP TABLE IF EXISTS `tb_kategori`;

CREATE TABLE `tb_kategori` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `kategori` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_kategori` (`id`, `idUser`, `kategori`, `terdaftar`) VALUES (1, 1, 'Kebutuhan Bangunan', '2025-09-16 13:18:04');
INSERT INTO `tb_kategori` (`id`, `idUser`, `kategori`, `terdaftar`) VALUES (2, 1, 'serkiler', '2025-09-17 09:20:11');
INSERT INTO `tb_kategori` (`id`, `idUser`, `kategori`, `terdaftar`) VALUES (3, 1, 'kesanggupan', '2025-09-17 09:20:18');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1, 1, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-16 13:16:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (2, 1, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Logout', '2025-09-16 13:16:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3, 1, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-16 13:16:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4, 1, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Logout', '2025-09-16 13:20:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (5, 2, '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-16 13:21:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (7, 1, '36.80.122.77', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2025-09-17 08:22:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (8, 1, '36.80.122.77', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-17 08:28:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (9, 1, '36.80.122.77', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Logout', '2025-09-17 08:36:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (10, 3, '36.80.122.77', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-17 08:36:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (11, 3, '36.80.122.77', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Logout', '2025-09-17 08:36:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (12, 3, '36.80.122.77', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-17 08:36:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (13, 1, '36.80.122.77', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-17 08:36:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (14, 1, '36.80.122.77', 'Mozilla/5.0 (Linux; Android 14; 22021211RG Build/UKQ1.231207.002; ) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/140.0.7339.51 Mobile Safari/537.36', 'Login', '2025-09-17 09:18:15');


#
# TABLE STRUCTURE FOR: tb_poskeuangan
#

DROP TABLE IF EXISTS `tb_poskeuangan`;

CREATE TABLE `tb_poskeuangan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `pos` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_poskeuangan` (`id`, `idUser`, `pos`, `terdaftar`) VALUES (1, 1, 'RSTSP OPSHID FKYME 2025', '2025-09-16 13:17:36');


#
# TABLE STRUCTURE FOR: tb_transaksi
#

DROP TABLE IF EXISTS `tb_transaksi`;

CREATE TABLE `tb_transaksi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `idPoskeuangan` int(11) NOT NULL,
  `idKategori` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `jenis` varchar(16) NOT NULL,
  `nominal` varchar(256) NOT NULL,
  `keterangan` text NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_transaksi` (`id`, `idUser`, `idPoskeuangan`, `idKategori`, `tanggal`, `jenis`, `nominal`, `keterangan`, `terdaftar`) VALUES (1, 1, 1, 1, '2025-09-16', 'Masuk', '23000000', 'Serkiler ', '2025-09-16 13:18:53');


#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `tptLahir` varchar(256) NOT NULL,
  `tglLahir` date NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `tptLahir`, `tglLahir`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Bryan Achmad Bayu Aji', 'Laki-Laki', 'Kudus', '2005-04-21', '085740621654', 'turnerbryan425@gmail.com', 'Ds.Kandangmas, Kec. Dawe, Kabupaten Kudus, Jawa Tengah', 'admin', '$2y$10$C/E27WgKJHk9I7K8wvhkjOcgSgMOHB6LcVgjA/1tw4BtGjIKDLbiu', 'no-image.png', 'blue', 'Administrator', 'Ya', '2023-11-07 23:23:09');
INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `tptLahir`, `tglLahir`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (3, 'Dedy Tri Santoso', 'Laki-Laki', 'Kudus', '1995-09-17', '08576666', 'dedy@gmail.com', 'kudusa', 'dedy', '$2y$10$K5V/x4yGnV5SDSlck9RBq.N7ztW.R/abaP5FlrZaBGTzL2BfgI9hS', 'no-image.png', 'blue', 'Administrator', 'Ya', '2025-09-17 08:30:43');
INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `tptLahir`, `tglLahir`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (4, 'Maulida', 'Perempuan', 'Kudus', '2000-09-17', '0857263637272', 'maulida@gmail.com', 'kudus', 'maulida', '$2y$10$qc7V2v1Eb3HCgApRMX96uO4Lgm31UaluHH8RPGYTcIpNDgbZ2YLGa', 'no-image.png', 'blue', 'Administrator', 'Ya', '2025-09-17 09:22:01');


